/* Boule de cristal:
Version française de Crystal Ball
*/

/*Crystal Ball
 by Becky Stewart
 for Adventures in Arduino, Wiley (2015)
 
 Hardware:
 * 2 10M Ohm resistors
 * 1 RGB LED with a common cathode

Copyright 2015 Becky Stewart

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.  
 */

#include <CapacitiveSensor.h>

// Les broches des LED
int brocheRouge = 9;
int brocheVert = 10;
int brocheBleu = 11;
// Les broches du capteur capacitif
int brocheCapteur = 2;
int brocheSignal = 4;

// Le seuil de déclenchement du capteur
int seuil = 1000;

CapacitiveSensor capteurTactile = CapacitiveSensor(brocheSignal, brocheCapteur);

void setup() {
  pinMode(brocheRouge, OUTPUT);
  pinMode(brocheVert, OUTPUT);
  pinMode(brocheBleu, OUTPUT);
  
  Serial.begin(9600);
}

void loop() {
  long valeurCapteur = capteurTactile.capacitiveSensor(30);
  Serial.println(valeurCapteur);
  // Cas où la valeur est supérieure au seuil
  if(valeurCapteur > seuil) {

    // Déterminer la couleur en fonction de la valeur du
    // capteur
    int valeurRouge = map(valeurCapteur, seuil, 90000, 0, 255);
    int valeurVert = map(valeurCapteur, seuil, 20000, 0, 255);
    int valeurBleu = map(valeurCapteur, seuil, 30000, 0, 255);

    // Allumage de la couleur rouge, puis verte, puis bleue
    analogWrite(brocheRouge, valeurRouge);
    analogWrite(brocheVert, valeurVert);
    analogWrite(brocheBleu, valeurBleu);
  }
  else{
    // si la valeur est inférieure au seuil, éteindre les LED
    digitalWrite(brocheRouge, LOW);
    digitalWrite(brocheVert, LOW);
    digitalWrite(brocheBleu, LOW);
  }
}
